/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

// mate planes  conv functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"

static int mateCount = 0;

HRESULT MatePlanesPrior()
{
	START_METHOD("MatePlanesPrior")

	HRESULT status = CONV_SUCCESS;	
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Select entities to be Mated");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *pSelectionSet = NULL;

	status = activeGraphicDoc->GetSelection(GetBSTR("Geometric"), &pSelectionSet);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(pSelectionSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pDispObject = NULL;
	IGeometric *pFirstGeometric = NULL;
	IGeometric *pSecondGeometric = NULL;

	status = pObjectIt->start(&pDispObject);
	CHECK_RETURN_STATUS(status)
	pFirstGeometric = CAST(IGeometric, pDispObject);

	status = pObjectIt->Next(&pDispObject);
	CHECK_RETURN_STATUS(status)
	pSecondGeometric = CAST(IGeometric, pDispObject);

	IDesign *pDesign;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status);

	double offset = 0.0;
	CString name;
	name.Format("DemoMate %d", ++mateCount);
	
	status = MatePlanes(pDesign, pFirstGeometric, pSecondGeometric, offset, name);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Mate Planes");
	CHECK_RETURN_STATUS(status)

	END_METHOD("MatePlanesPrior")
}
